// Carrega os dados da Loja da qual está sendo feita a revisão
function carregarLojaPagamento() {
    const blocoSelecionado = document.querySelector('.bloco-loja.selecionada');
    const lojaSlug = blocoSelecionado
        ? blocoSelecionado.getAttribute('data-loja')
        : null;

    if (!lojaSlug) return;

    const formData = new FormData();
    const digits = String(lojaSlug).replace(/\D/g, '');

    if (digits.length >= 14) {
        // veio CNPJ (ex.: quando você manda data.loja da revisão)
        formData.append('cnpj', digits);
    } else {
        // veio slug (ex.: seleção atual do select)
        formData.append('loja_slug', lojaSlug);
    }

    // skeleton
    document.querySelectorAll('.loja-retirada').forEach(div => {
        div.innerHTML = `
        <div class="bloco-loja-skeleton">
            <div class="skeleton-title shimmer" style="width: 100px; height: 20px; margin-bottom: 10px;"></div>
            <div class="skeleton-text shimmer" style="width: 80%; height: 14px; margin-bottom: 6px;"></div>
            <div class="skeleton-text shimmer" style="width: 60%; height: 14px; margin-bottom: 6px;"></div>
            <div class="skeleton-map shimmer" style="width: 100%; height: 120px; border-radius: 8px;"></div>
        </div>
        `;
    });

    fetch('/wp-content/themes/app/mobile-view/server-side/offer-control/server-processing-stores.php', {
        method: 'POST',
        body: formData
    })
    .then(res => res.text())
    .then(html => {
        document.querySelectorAll('.loja-retirada').forEach(div => {
            div.innerHTML = html;
            const iframe = div.querySelector('.mapa-loja iframe');
            if (iframe) iframe.style.display = 'block';
        });
    });
}

// 👉 Atualiza o nome da loja nas labels
function atualizarNomeLojaNasLabels() {
    const blocoSelecionado = document.querySelector('.bloco-loja.selecionada');
    const lojaSlug = blocoSelecionado
        ? blocoSelecionado.getAttribute('data-loja')
        : null;

    const lojaLabel = document.querySelectorAll('.loja-label');
    if (lojaSlug) {
        const nomeLoja = lojaSlug.text;

        lojaLabel.forEach(label => {
            label.innerText = nomeLoja;
        });
    }
}