// Gerar cupom de desconto
$("#getCupom").on("click", function(){
    $(this).css('display', 'none');
    $.ajax({
            type: "POST",
            url: window.location.origin + "/wp-content/themes/app/mobile-view/server-side/coupon-control/create-coupon.php",
            success: function(data){
            if(data != 0){
            $('#cupons').addClass('open');
            $('.boxGetCupom').remove();
            $('.valueCredit').each(function() {
                $(this).html('0,00');
            });
            const elements = document.querySelectorAll('.valueCupom');
            elements.forEach(element => {
                const value = parseInt(element.innerHTML);
                element.innerHTML = value + 1;
            });
            setTimeout(() => {
                $("#relatorioCupom").prepend(data);
                $('#relatorioCupom .item').css({'opacity': 0,'display': 'block'}).animate({'opacity': 1}, 50);
            }, "700");
            }else{
            alert('Ops! Houve um erro, tente novamente mais tarde.');
            $("#getCupom").css('display', 'block');
            }
        }   
    });
});

function mostrarSkeletonsCompleto({
    containerProdutos = '#productsArea',
    containerCategorias = '#categoriesArea',
    qtdProdutos = 4,
    qtdCategorias = 6
        } = {}) {
    // Produtos
    const produtosContainer = document.querySelector(containerProdutos);
    if (produtosContainer) {
        produtosContainer.innerHTML = `
        <div class="skeleton skeleton-titulo mb-4" style="width: 180px; height: 28px;"></div>
        <div class="row" id="skeletonRowProdutos"></div>
    `;
    
        const rowContainer = produtosContainer.querySelector('#skeletonRowProdutos');
        
        for (let i = 0; i < qtdProdutos; i++) {
            const skeletonProduto = document.createElement('div');
            skeletonProduto.className = 'col-lg-4 col-md-3 col-sm-6 col-6 mb-3 skeleton-card';
            skeletonProduto.innerHTML = `
            <div class="skeleton-loader blocoOfertaApp">
                <div class="skeleton skeleton-etiqueta"></div>
                <div class="skeleton skeleton-imagem"></div>
                <div class="skeleton skeleton-nome"></div>
                <div class="skeleton skeleton-preco"></div>
                <div class="skeleton skeleton-botao"></div>
            </div>
            `;
            rowContainer.appendChild(skeletonProduto);
        }
    }  

    // Categorias
    const categoriasContainer = document.querySelector(containerCategorias);
    if (categoriasContainer) {
        categoriasContainer.innerHTML = '';
        for (let i = 0; i < qtdCategorias; i++) {
        const skeletonCircle = document.createElement('div');
        skeletonCircle.className = 'sectionCircle text-center skeleton-circle';
        skeletonCircle.innerHTML = `
            <div class="circleWrapper">
            <div class="skeleton skeleton-img-circle rounded-circle"></div>
            </div>
            <div class="skeleton skeleton-text mt-2 mx-auto" style="width: 60px;"></div>
        `;
        categoriasContainer.appendChild(skeletonCircle);
        }
    }
}

function showFilterSkeleton(containerId, lines = 4) {
    const box = document.getElementById(containerId);
    if (!box) return;
    let skeletonHTML = '';
    for (let i = 0; i < lines; i++) {
        skeletonHTML += `
        <div class="skeleton-filter">
            <div class="skeleton-filter-box"></div>
            <div class="skeleton-filter-line" style="width:${60 + Math.random() * 30}%"></div>
        </div>
        `;
    }
    box.innerHTML = skeletonHTML;
}

function mostrarSkeletonProdutos(containerSelector = '#listaProdutos', qtd = 3) {
    const container = typeof containerSelector === 'string'
        ? document.querySelector(containerSelector)
        : containerSelector;

    if (!container) return;

    container.innerHTML = ''; // Limpa antes

    const row = document.createElement('div');
    row.className = 'row';

    for (let i = 0; i < qtd; i++) {
        const col = document.createElement('div');
        col.className = 'col-lg-4 col-md-4 col-sm-6 col-6 mb-3';

        col.innerHTML = `
        <div class="blocoOfertaApp skeleton-card" style="border-radius: 10px; border: 1px solid #eee; padding: 16px; text-align: center; background: #fff;">
            <div style="background-color:rgb(255, 255, 255); border-radius: 8px 8px 0 0; padding: 6px;">
            <div class="skeleton skeleton-economia" style="height: 16px; width: 60%; margin: 0 auto;"></div>
            </div>

            <div class="skeleton skeleton-imagem mt-3 mb-2" style="height: 120px; width: 100px; margin: 0 auto; border-radius: 6px;"></div>
            <div class="skeleton skeleton-aviso mb-2" style="height: 8px; width: 60%; margin: 0 auto;"></div>
            <div class="skeleton skeleton-nome mb-2" style="height: 16px; width: 90%; margin: 0 auto;"></div>
            <div class="skeleton skeleton-preco mb-2" style="height: 20px; width: 80%; margin: 0 auto;"></div>
            <div class="skeleton skeleton-link" style="height: 12px; width: 50%; margin: 0 auto;"></div>
        </div>
        `;

        row.appendChild(col);
    }

    container.appendChild(row);
}

// Adicionar ação para o botão de cancelar no modal
$("#botaoCancelar").on("click", function(){
    $("#modalConfirmacao").removeClass("open");
});

const STORAGE_KEY = 'ultimaVisualizacaoNotificacao';

// chama isso quando o usuário REALMENTE vê (abre) o modal
function registrarVisualizacaoNotificacao() {
  localStorage.setItem(STORAGE_KEY, String(Date.now()));
}

function getTimestampUltimaNotificacao() {
  const el = document.getElementById('ultimaNotificacao');
  if (!el) return 0;

  const iso = el.getAttribute('data-horario');
  if (!iso) return 0;

  const ts = new Date(iso).getTime();
  return Number.isFinite(ts) ? ts : 0;
}

function verificarNotificacoes() {
  // se não tem notificação, não faz nada
  if (typeof countTabloide !== 'undefined' && countTabloide <= 0) return;

  const ultimaVisualizacao = parseInt(localStorage.getItem(STORAGE_KEY) || '0', 10);
  const tsUltimaNotificacao = getTimestampUltimaNotificacao();

  // se tem notificação mais nova do que a última visualização → abre
  if (tsUltimaNotificacao > ultimaVisualizacao) {
    abrirNotificacao();
  }
}

function abrirNotificacao() {
  $('#notificacao').addClass('open');
  document.getElementById("notificacaoBadge").style.display = "none";
  registrarVisualizacaoNotificacao();
}

// roda ao carregar a página
verificarNotificacoes();

// opcional: também registrar quando FECHA (se você prefere “marcar como visto” ao fechar)
document.getElementById('closeModal')?.addEventListener('click', () => {
  registrarVisualizacaoNotificacao();
});


// Botão para voltar ao topo
document.getElementById('btnUponPage').addEventListener('click', function (e) {
    e.preventDefault();

    // console.log('Scrolling to top...');
    window.scrollTo({
        top: 0,
        behavior: 'smooth' 
    });
});

function loadBanners(banners) {
    const container = document.getElementById('bannerRotate');
    const bannersRotateDiv = document.querySelector('.bannersRotate');

    let currentSlide = 0;
    if ($('#bannerRotate').hasClass('slick-initialized')) {
        currentSlide = $('#bannerRotate').slick('slickCurrentSlide');
        $('#bannerRotate').slick('unslick');
    }

    container.innerHTML = '';
    document.getElementById('bannerSkeleton').style.display = 'none';
    bannersRotateDiv.classList.remove('banner-none');

    banners.forEach(banner => {
        const item = document.createElement('div');
        item.dataset.id = banner.id;
        item.dataset.nome = banner.nome;
        item.dataset.link = banner.link;
        item.dataset.img = banner.imagem;

        item.innerHTML = `
            <div class="banner-container">
                <a href="${banner.link}" target="_blank">
                    <img src="${banner.imagem}" alt="${banner.nome}" class="img-fluid">
                </a>
            </div>
        `;

        container.appendChild(item);
    });

    $('#bannerRotate').slick({
        slidesToShow: 1,
        slidesToScroll: 1,
        infinite: true,
        dots: true,
        arrows: true,
        autoplay: true,
        autoplaySpeed: 5000,
        adaptiveHeight: true
    });

    $('#bannerRotate').slick('slickGoTo', currentSlide);
}
 
function iniciarCronometro(element) {
    const start = new Date(element.dataset.start).getTime();
    const end = new Date(element.dataset.end).getTime();

    function atualizar() {
        const agora = new Date().getTime();
        const diferenca = end - agora;

        if (diferenca <= 0) {
            element.querySelector('.days').innerText = '00';
            element.querySelector('.hours').innerText = '00';
            element.querySelector('.minutes').innerText = '00';
            element.querySelector('.seconds').innerText = '00';
            return;
        }

        const dias = Math.floor(diferenca / (1000 * 60 * 60 * 24));
        const horas = Math.floor((diferenca % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
        const minutos = Math.floor((diferenca % (1000 * 60 * 60)) / (1000 * 60));
        const segundos = Math.floor((diferenca % (1000 * 60)) / 1000);

        element.querySelector('.days').innerText = dias.toString().padStart(2, '0');
        element.querySelector('.hours').innerText = horas.toString().padStart(2, '0');
        element.querySelector('.minutes').innerText = minutos.toString().padStart(2, '0');
        element.querySelector('.seconds').innerText = segundos.toString().padStart(2, '0');
    }

    atualizar();
    setInterval(atualizar, 1000);
}

function abrirLateralFiltro() {
    buildSectionsForStore('geral');
    document.querySelector('.filter__page').classList.add('actived');
    document.querySelector('body').classList.add('modal__actived');

}

document.addEventListener('click', function (event) {
    const filterPage = document.querySelector('.filter__page');
    const container = document.querySelector('.container__filter__page');

    if (filterPage && container) {
        if (filterPage.contains(event.target) && !container.contains(event.target)) {
            filterPage.classList.remove('actived');
            document.body.classList.remove('modal__actived');

            document.querySelector('.filter__page.half_page').classList.remove('actived'); 
            document.querySelector('body').classList.remove('modal__actived');

            const idSecaoAtual = document.getElementById('idSecaoAtual');
            const sectionId = idSecaoAtual?.value;

            if (idSecaoAtual) idSecaoAtual.value = '';
            selectSecao.value = '';
        }
    }
});

// Quando clicar no campo de busca
if (searchInput) {
    searchInput.addEventListener('focus', abrirLateralFiltro);
}

// Quando clicar no ícone da lupa
if (searchIcon) {
    searchIcon.addEventListener('click', abrirLateralFiltro);
}

$("body").off("click.openModalProduto", ".blocoOfertaApp").on("click.openModalProduto", ".blocoOfertaApp", function (e) {

    // evita loop: clique dentro do modal não reabre
    if ($(this).closest('#modalProduto').length) return;

    // se clicou dentro do carrinho/quantidade/add-cart, não abre modal
    if ($(e.target).closest('.adicionar-carrinho, .quantidade, .btn-mais, .btn-menos, .input-quantidade, .add-cart, .btn-adicionar').length) {
        return;
    }

    // se clicou no ver opções, deixa o handler dele agir
    if ($(e.target).closest('.see-family').length) {
        return;
    }

    const $card  = $(this);
    const $bloco = $card.closest('.blocoOfertaApp');

    const idBloco       = $bloco.data('id') || '';
    const nomeProduto   = ($bloco.find('.nomeOferta').first().text() || '').trim();
    const imagemProduto = $bloco.find('img').first().attr('src') || '';
    const loja          = $bloco.closest('.individual').attr('data-loja') || '';

    const temFamilia    = ($bloco.attr('data-familia') ?? '').toString().trim();
    const smartCampaign = ($bloco.attr('data-smart') ?? '').toString().trim();

    const ecomAttr    = $bloco.attr('data-ecommerce');
    const isEcommerce = (ecomAttr == '1' || ecomAttr == 1 || ecomAttr === true || ecomAttr == 'true');

    const addCodigo = $bloco.find('.btn-adicionar').first().attr('data-id') || '';

    // limite do card (se tiver)
    const limite = $bloco.find('.input-quantidade').first().attr('max') || 999;

    // ===== Atualiza modal =====
    $('#imagemProduto').attr('src', imagemProduto);
    $('#modalProduto h3').text(nomeProduto);
    $('#nomeProduto').text(nomeProduto);

    // ✅ input hidden -> val()
    $('#nomeLojaProduto').val(loja ? `Loja: ${loja}` : '');

    // ===== Preço do modal: SEMPRE substitui a div inteira =====
    const $priceBox = $bloco.find('.precoOferta').first();

    // pega preço antigo se existir
    let oldPrice = ($priceBox.find('del').text() || '').replace('R$', '').trim();

    // pega preço atual (último span). Se não existir, usa regex no texto
    let newPrice = ($priceBox.find('span').last().text() || '').replace('R$', '').trim();

    if (!newPrice) {
        const txt = ($priceBox.text() || '').replace(/\s+/g, ' ').trim();
        const matches = txt.match(/R\$\s*[\d.,]+/g);
        if (matches && matches.length) newPrice = matches[matches.length - 1].replace('R$', '').trim();
    }

    const $modalPriceBox = $('#modalProduto .infoProduto .precoOferta');

    // ✅ regra: se não tem antigo, mostra só o novo (sem “R$ R$” duplicado)
    if (oldPrice && newPrice && oldPrice !== newPrice) {
        $modalPriceBox.html(`
            <del>R$ ${oldPrice}</del>
            <span>R$ ${newPrice}</span>
        `);
    } else if (newPrice) {
        $modalPriceBox.html(`<span>R$ ${newPrice}</span>`);
    } else {
        $modalPriceBox.html(`<span class="text-muted">Preço indisponível</span>`);
    }

    // ===== Limite do input no modal =====
    const inputModal = document.querySelector('#modalProduto .input-quantidade');
    if (inputModal) {
        inputModal.setAttribute('max', limite);
        inputModal.value = 1;
    }

    // ===== Botão modal (Comprar vs Ver opções) =====
    const $cartBlock = $('#modalProduto .adicionar-carrinho');
    const $btnModal  = $('#addCart');

    // mostra carrinho se ecommerce OU tem familia OU tem smart_campaign
    if (isEcommerce || (temFamilia && temFamilia !== "0") || (smartCampaign && smartCampaign !== "0" && smartCampaign !== "null")) {
        $cartBlock.removeClass('d-none');
    } else {
        $cartBlock.addClass('d-none');
    }

    if (temFamilia && temFamilia !== "" && temFamilia !== "0") {
        $btnModal
            .removeClass('btn-adicionar add-cart')
            .addClass('btn-familia see-family')
            .html('<i class="fa-solid fa-list-ul"></i> Ver opções')
            .attr('data-familia', temFamilia);

        // smart pode existir ou não
        if (smartCampaign && smartCampaign !== "0" && smartCampaign !== "null") {
            $btnModal.attr('data-smart', smartCampaign);
        } else {
            $btnModal.removeAttr('data-smart');
        }

        // não é compra
        $btnModal.removeAttr('data-id');

    } else {
        $btnModal
            .removeClass('btn-familia see-family')
            .addClass('btn-adicionar add-cart')
            .html('<i class="fa-solid fa-cart-shopping"></i> Comprar')
            .removeAttr('data-familia')
            .attr('data-id', addCodigo || '');

        // mantém smart se você usa no carrinho
        if (smartCampaign && smartCampaign !== "0" && smartCampaign !== "null") {
            $btnModal.attr('data-smart', smartCampaign);
        } else {
            $btnModal.removeAttr('data-smart');
        }
    }

    // attrs do botão alterar imagem
    $('#search_imagem').attr('data-id', idBloco);
    $('#search_imagem').attr('data-imagem', nomeProduto);
    $('#search_imagem').attr('data-oferta', idBloco);

    $('#modalProduto').addClass('open');
});

async function LoadStoresBlock() {
    // mostra skeleton imediatamente
    renderStoresSkeleton(4);

    try {
        const resp = await fetch('/wp-content/themes/app/mobile-view/server-side/offer-control/server-processing-stores.php', {
            method: 'POST'
        });
        const html = await resp.text();

        const lista = document.getElementById('listaLojas');
        if (!lista) return;

        lista.innerHTML = html;

        const listaBlocos = lista.querySelectorAll('.bloco-loja');

        if (!listaBlocos.length) return;

        // garante que mapas apareçam
        listaBlocos.forEach(bloco => {
            const mapaAtual = bloco.querySelector('.mapa-loja');
            if (mapaAtual) mapaAtual.style.display = 'block';
        });

        // 🔥 Seleciona automaticamente o primeiro bloco
        listaBlocos[0].classList.add('selecionada');

        // clique para selecionar
        listaBlocos.forEach(bloco => {
            bloco.addEventListener('click', function () {
                listaBlocos.forEach(div => div.classList.remove('selecionada'));
                this.classList.add('selecionada');
                loadSection();
                loadNewspaper(ALL_NEWSPAPER);
            });
        });

    } catch (e) {
        const lista = document.getElementById('listaLojas');
        if (lista) {
            lista.innerHTML = `
                <div class="skel-loja" style="text-align:center;padding:24px;">
                <div style="margin-bottom:8px;">Não foi possível carregar as lojas.</div>
                <button class="btn btn-sm btn-outline-primary" onclick="LoadStoresBlock()">Tentar novamente</button>
                </div>`;
        }
        console.error('Erro ao carregar lojas:', e);
    }
}

function loadNewspaper(newspapers) {
    const container = document.getElementById('listaJornais');
    if (!container) return;

    container.innerHTML = '';

    if (!Array.isArray(newspapers) || newspapers.length === 0) {
        container.innerHTML = '<p class="no-results">Nenhum jornal encontrado.</p>';
        return;
    }

    const hoje = new Date();
    let encontrou = false;

    const blocoSelecionado = document.querySelector('.bloco-loja.selecionada');
    let lojaSlug = blocoSelecionado
        ? blocoSelecionado.getAttribute('data-loja')
        : null;


    newspapers.forEach(jornal => {
        // ----- FILTRO POR LOJA -----
        // Ex: "1,2,4" ou "loja-1,loja-2"
        const lojasJornal = (jornal.loja || ''); // só números

        if (lojaSlug && !lojasJornal.includes(lojaSlug)) {
            // jornal não atende a loja selecionada
            return;
        }

        // ----- FILTRO POR PERÍODO -----
        const dataInicial = jornal.data_inicial && jornal.data_inicial !== '0000-00-00 00:00:00'
            ? new Date(jornal.data_inicial.replace(' ', 'T'))
            : null;

        const dataFinal = jornal.data_final && jornal.data_final !== '0000-00-00 00:00:00'
            ? new Date(jornal.data_final.replace(' ', 'T'))
            : null;

        const foraDoPeriodo =
            (dataInicial && hoje < dataInicial) ||
            (dataFinal && hoje > dataFinal);

        if (foraDoPeriodo) {
            // fora da vigência -> não mostra
            return;
        }

        // ----- MONTA CARD -----
        const card = document.createElement('div');
        card.className = 'card-newspaper position-relative';
        card.dataset.id = jornal.id;
        card.dataset.nome = jornal.nome;
        card.dataset.img = jornal.imagem;
        card.dataset.inicial = jornal.data_inicial;
        card.dataset.final = jornal.data_final;
        card.dataset.loja = jornal.loja || '';
        card.dataset.publico = jornal.publico || '';

        card.innerHTML = `
            <a href="${jornal.imagem}" target="_blank" rel="noopener noreferrer">
                <img src="${jornal.imagem}" alt="${jornal.nome}" class="card-img-top img-fluid">
            </a>
        `;

        container.appendChild(card);
        encontrou = true;
    });

    if (!encontrou) {
        container.innerHTML = '<p class="no-results">Nenhum jornal disponível no momento.</p>';
    }
}


// Faz o botao aparece e sumir de acordo onde esta na pagina
document.addEventListener("scroll", function () {
    const scrollPosition = window.scrollY;
    const screenHeight = window.innerHeight;
    const btn = document.getElementById("btnUponPage");

    if (scrollPosition > screenHeight) {
        btn.classList.add("show");
    } else {
        btn.classList.remove("show");
    }
});



const observer = new MutationObserver((mutationsList) => {
    mutationsList.forEach(mutation => {
        if (mutation.type === 'attributes' && mutation.attributeName === 'class') {
            if (mutation.target.classList.contains('modal')) {
                atualizarOverflow();
            }
        }
    });
});

// Observa todos os modais
document.querySelectorAll('.modal').forEach(modal => {
    observer.observe(modal, { attributes: true });
});

function atualizarOverflow() {
    if ($('.modal.open').length) {
        $('body').css('overflow', 'hidden').addClass('modal-open');;
    } else {
        $('body').css('overflow', 'auto').removeClass('modal-open');;
    }
}

// Pega o CNPJ com o slug da loja
async function pegarCNPJ(lojaSlug) {
    if (!lojaSlug) return null;

    const fd = new FormData();
    fd.append('action', 'get_cnpj');   // a ação que o PHP vai tratar
    fd.append('loja_slug', lojaSlug);  // o slug da loja

    const res = await fetch('/wp-content/themes/app/mobile-view/server-side/offer-control/server-processing-stores.php', {
        method: 'POST',
        body: fd
    });

    if (!res.ok) {
        console.error('Erro HTTP ao buscar CNPJ:', res.status);
        return null;
    }

    // espera JSON: { success: true, cnpj: "..." }
    let data;
    try {
        data = await res.json();
    } catch (e) {
        console.error('Resposta não é JSON válida.');
        return null;
    }

    if (data?.success && typeof data.cnpj === 'string' && data.cnpj.trim() !== '') {
        return data.cnpj.trim();
    }

    console.warn('CNPJ não retornado pelo servidor:', data);
    return null;
}

// Verifica se a loja está aberta para ecommerce
async function verificarLojaAberta() {
 
    try {
        await fetch('/wp-content/themes/app/mobile-view/server-side/offer-control/server-processing-ecommerce.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({
                action: 'verificarLojaHorario'
            })
        });
    } catch (err) {
        console.error(err);
    }

}

// let wppCommunityLink = null;
// let wppCommunityInterval = null;
// let wppCommunityEventsBound = false;


// function modalWppCommunity(ativo = false){
//     if (!ativo) return;
    
//     fetch("/wp-content/themes/app/mobile-view/server-side/access-control/logged-in/server-processing-wpp-group-check.php")
//     .then(res => res.json())
//     .then(data => {
//         if (!data.showModal) return;

//         const modal = document.getElementById("ctaModal");
//         const btnJoin = document.getElementById("joinNowBtn");
//         const btnLater = document.getElementById("laterBtn");
//         const countdownEl = document.getElementById("countdown");

//         let countdown = 15;
//         wppCommunityLink = data.invite_link;

//         // mostra modal
//         modal.style.display = "flex";
//         countdownEl.textContent = countdown;

//         // registra eventos só UMA vez
//         if (!wppCommunityEventsBound) {
//             btnJoin.addEventListener("click", () => {
//                 if (wppCommunityInterval) clearInterval(wppCommunityInterval);
//                 modal.style.display = "none";
//                 if (wppCommunityLink) window.open(wppCommunityLink, "_blank");
//             });

//             btnLater.addEventListener("click", () => {
//                 if (wppCommunityInterval) clearInterval(wppCommunityInterval);
//                 modal.style.display = "none";
//             });

//             wppCommunityEventsBound = true;
//         }

//         // zera qualquer contador anterior
//         if (wppCommunityInterval) {
//             clearInterval(wppCommunityInterval);
//         }

//         // inicia novo contador
//         wppCommunityInterval = setInterval(() => {
//             countdown--;
//             countdownEl.textContent = countdown;

//             if (countdown <= 0) {
//                 clearInterval(wppCommunityInterval);
//                 modal.style.display = "none";
//                 if (wppCommunityLink) window.open(wppCommunityLink, "_blank");
//             }
//         }, 1000);
//     })
//     .catch(err => console.error("Erro:", err));
// }

// document.addEventListener("DOMContentLoaded", function() {
//     modalWppCommunity(true);
// });


// document.addEventListener("DOMContentLoaded", function() {
//     modalWppCommunity(true);
// });

async function checkarVisibility() {
    try {
        await fetch('/wp-content/themes/app/web-panel/modules/offer/server-side/section/server-processing-section-control.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ action: 'data_expiration' })
        });

        // 🔹 2) Atualiza o "Atualizado em: HH:MM"
        const lastUpdateSpan = document.getElementById('lastUpdateCheck');
        if (lastUpdateSpan) {
            const now = new Date();
            const hh  = String(now.getHours()).padStart(2, '0');
            const mm  = String(now.getMinutes()).padStart(2, '0');
            const today = String(now.getDate()).padStart(2, '0');
            lastUpdateSpan.textContent = `${hh}:${mm} - ${today}/${now.getMonth() + 1}/${now.getFullYear()}`;
            // console.log(`Atualizado em: ${hh}:${mm}`);
        }

        verificarLojaAberta();


    } catch (e) {
        console.error('Erro ao checar visibilidade:', e);
    }
}

// Inicializa tudo em uma só requisição
let ALL_DATA  = null;
let AlreadyLoaded = false;

let ALL_BANNER = [];
let ALL_AGENDA = [];
let ALL_NEWSPAPER = [];
let ALL_STORES = [];
let ALL_CATEGORY = [];
let ALL_SECTION = [];
let ALL_PRODUCTS = [];
let ALL_CAMPAIGN = [];

let ECOMMERCE_ACTIVE = false;

async function loadAllInitFunction() {
    if (AlreadyLoaded) return;

    showFilterSkeleton('chips-agenda');
    showFilterSkeleton('chips-categoria');

    mostrarSkeletonsCompleto({
        containerProdutos: '#productsArea',
        containerCategorias: '#categoriesArea',
        qtdProdutos: 3,
        qtdCategorias: 13
    });

    // checkarVisibility(data.altered, data.campaign);
    await checkarVisibility();

    // 🔹 Agora espero carregar as lojas (criar .bloco-loja.selecionada)
    await LoadStoresBlock();

    fetch('/wp-content/themes/app/web-panel/modules/offer/server-side/server-processing-load-action.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ action: 'front', idUser: idUsuario, idTag: userTags })
    })
    .then(res => res.json())
    .then(async data => {             // 🔹 callback async
        if (!data.success) {
            throw new Error('Retorno all_functions sem success');
        }

        ALL_DATA = data;

        // BANNERS
        const banners = data.banners || [];
        setStoredBanners(banners);
        reloadBannersFromStorage();

        // JORNAIS
        const newspapers = data.newspapers || [];
        setStoredNewspapers(newspapers);

        const category = data.category || [];
        setStoredCategory(category);
        loadCategory(category); 

        const sections = data.sections || [];
        setStoredSections(sections);

        const products = data.products || [];
        setStoredProducts(products);

        const campaign = data.campaign || [];
        setStoredCampaign(campaign);
        
        ECOMMERCE_ACTIVE = data.ecommerce;

        renderizarCarrinho();

        // 🔹 Agora sim, lojaSlug existe e posso filtrar por loja
        loadSection();
        loadNewspaper(newspapers);

        AlreadyLoaded = true;
    })
    .catch(error => {
        console.error('Erro ao carregar o inicializador:', error);
        AlreadyLoaded = false; 
    });
}

loadAllInitFunction();