<?php  
	
	include(get_template_directory().'/web-panel/functions/database-connection.php');

	/**
	 * =======================
	 * INDICADOS
	 * =======================
	 */
	$indicados = array();  
	$queryIndicados = "
		SELECT nome, `data` 
		FROM customers 
		WHERE patrocinador = '{$idUsuario}'
	";
	$resultIndicados = $database_connection->query($queryIndicados);

	if ($resultIndicados && $resultIndicados->num_rows > 0) {
		while ($row = $resultIndicados->fetch_assoc()) {
			$indicados[] = array(
				"nome" => $row['nome'],
				"data" => $row['data'],
			);
		}
	}

	/**
	 * =======================
	 * EXTRATOS
	 * =======================
	 */
	$comissaoGeral = 0;
	$extratos = array();

	$argsExtratos = array(
		'post_type'      => 'extrato_comissao',
		'posts_per_page' => -1,
		'fields' => 'ids', // habilite se quiser só IDs para performance
		'meta_query'     => array(
			array(
				'key'     => 'recebedor',
				'value'   => $idUsuario,
				'compare' => '=',
			),
		),
	);

	$queryExtratos = new WP_Query($argsExtratos);

	if ($queryExtratos->have_posts()):
		while ($queryExtratos->have_posts()): $queryExtratos->the_post();

			// 🔹 Mantém compatibilidade com get_field e get_the_title
			$distribuidor = get_the_title(get_field('distribuidor'));
			$comissao     = floatval(str_replace(',', '.', get_field('valor')));
			$data         = get_the_date('d/m/Y');

			$comissaoGeral += $comissao;

			$extratos[] = array(
				'distribuidor' => $distribuidor,
				'comissao'     => $comissao,
				'data'         => $data,
			);

		endwhile;
	endif;


	/**
	 * =======================
	 * COMPRAS
	 * =======================
	 */
	$compras = array();
	$consumoBrutoGeral   = 0.00;
	$consumoLiquidoGeral = 0.00;
	$consumoCreditoGeral = 0.00;
	$economiaGeral       = 0.00;

	$sql = "
		SELECT id, cliente_id, cpf, valor_bruto, valor_liquido, 
			valor_total_compra_sem_clube, credito_utilizado,
			produtos_com_desconto, produtos_sem_desconto, `data`
		FROM sales 
		WHERE cliente_id = '{$idUsuario}'
		ORDER BY `data` DESC
	";
	$resultCompras = $database_connection->query($sql);

	if ($resultCompras && $resultCompras->num_rows > 0) {
		while ($row = $resultCompras->fetch_assoc()) {
			$valorBruto    = floatval(str_replace(',', '.', $row['valor_bruto']));
			$valorLiquido  = floatval(str_replace(array('.', ','), array('', '.'), $row['valor_liquido']));
			$valorSemClube = floatval(str_replace(array('.', ','), array('', '.'), $row['valor_total_compra_sem_clube']));
			$valorCredito  = floatval(str_replace(array('.', ','), array('', '.'), $row['credito_utilizado']));

			$economia = $valorBruto - $valorLiquido;
			$economiaGeral += $economia;

			$compras[] = array(
				'compraID'            => $row['id'],
				'compradorID'         => $row['cliente_id'],
				'compradorCPF'        => $row['cpf'],
				'valorBruto'          => number_format($valorBruto, 2, ',', '.'),
				'valorLiquido'        => number_format($valorLiquido, 2, ',', '.'),
				'ValorBrutoSemClube'  => number_format($valorSemClube, 2, ',', '.'),
				'credito'             => number_format($valorCredito, 2, ',', '.'),
				'economia'            => number_format($economia, 2, ',', '.'),
				'produtos'            => $row['produtos_com_desconto'],
				'produtosSemDesconto' => $row['produtos_sem_desconto'],
				'data'                => date('d/m/Y H:i:s', strtotime($row['data'])),
			);
		}
	}

	/**
	 * =======================
	 * CUPONS DE DESCONTO
	 * =======================
	 */
	$cuponsDesconto   = array();  
	$cuponsDisponiveis = 0;

	$argsCuponsDesconto = array(
		'post_type'      => 'cupom_desconto',
		'posts_per_page' => -1,
		'fields' => 'ids', // habilite se quiser só IDs para performance
		'meta_query'     => array(
			array(
				'key'     => 'usuario_cupom_desconto',
				'value'   => $idUsuario,
				'compare' => '=',
			),
		),
	);
	$queryCuponsDesconto = new WP_Query($argsCuponsDesconto);

	if ($queryCuponsDesconto->have_posts()):
		while ($queryCuponsDesconto->have_posts()): $queryCuponsDesconto->the_post();
			$statusCupom = get_field('status_cupom_desconto');

			$cuponsDesconto[] = array(
				"codigo" => get_the_title(),
				"data"   => get_the_date('d/m/Y'),
				'valor'  => get_field('valor_cupom_desconto'),
				'status' => $statusCupom
			);

			if ($statusCupom == 0) { 
				$cuponsDisponiveis++; 
			}
		endwhile;
	endif;

?>