<?php
session_start();
require_once $_SERVER['DOCUMENT_ROOT'] . '/wp-load.php';
header('Content-Type: application/json; charset=utf-8');

$data = $_POST ?? [];
if (!isset($database_connection) || !$database_connection) {
  echo json_encode(['error'=>'Falha na conexão com o banco.']); exit;
}

function norm_date($s){
  $s = trim((string)$s);
  if ($s === '') return $s;
  // dd/mm/aaaa -> aaaa-mm-dd
  if (strpos($s,'/') !== false) {
    [$d,$m,$y] = array_pad(explode('/',$s,3),3,'');
    if (ctype_digit($d) && ctype_digit($m) && ctype_digit($y) && strlen($y)===4) {
      return sprintf('%04d-%02d-%02d', (int)$y,(int)$m,(int)$d);
    }
  }
  return $s; // já está em ISO?
}

function cadastrar_usuario(array $data, mysqli $db){
  $nome         = $data['nome']        ?? '';
  $nascimento   = norm_date($data['nascimento'] ?? '');
  $celular      = $data['celular']     ?? '';
  $cep          = $data['cep']         ?? '';
  $estado       = $data['estado']      ?? '';
  $cidade       = $data['cidade']      ?? '';
  $bairro       = $data['bairro']      ?? '';
  $rua          = $data['rua']         ?? '';
  $numero       = (int)($data['numero'] ?? 0);
  $loja         = $data['loja']        ?? '';
  $genero       = $data['genero']      ?? '';
  $cliente_uuid = $_SESSION['usuario']['id'] ?? '';

  if ($cliente_uuid === '') return ['error'=>'Sessão inválida. Faça login novamente.'];

  // Info existentes (para API e sync)
  $cpf   = get_info('cpf',   $cliente_uuid);
  $email = get_info('email', $cliente_uuid);

  // UPDATE (prepared)
  $sql = "UPDATE customers SET 
            nome=?, celular=?, cep=?, estado=?, cidade=?, bairro=?, rua=?, numero=?, 
            data_nascimento=?, loja_mais_frequentada=?, genero=?
          WHERE cliente_uuid=?";
  $stmt = $db->prepare($sql);
  if (!$stmt) return ['error'=>'Erro ao preparar atualização: '.$db->error];

  $stmt->bind_param(
    'sssssssissss',
    $nome, $celular, $cep, $estado, $cidade, $bairro, $rua, $numero,
    $nascimento, $loja, $genero, $cliente_uuid
  );

  if (!$stmt->execute()) {
    $err = $stmt->error;
    $stmt->close();
    return ['error'=>'Ops! Houve um erro ao atualizar os dados. '.$err];
  }
  $stmt->close();

  // Chama API externa (não bloqueia a resposta se falhar)
  try {
    save_user_api($nome, $cpf, $rua, $numero, $bairro, $cidade, $estado, $cep, $celular, $email, $genero);
  } catch (\Throwable $e) {
    error_log('[save_user_api] '.$e->getMessage());
  }

  // Sincroniza comunidade/grupos conforme seu critério
  try {
    syncCommunityAfterPhoneUpdate($db, $cliente_uuid, $celular, $cpf);
  } catch (\Throwable $e) {
    error_log('[syncCommunityAfterPhoneUpdate] '.$e->getMessage());
  }

  return ['success'=>'Cadastro atualizado com sucesso!'];
}

// --- helpers já estavam definidos no seu arquivo:
function only_digits($s){ return preg_replace('/\D+/', '', (string)$s); }
function build_person_key_from_phone($phone){
  $d = only_digits($phone);
  if ($d === '') return '';
  if (strpos($d,'55') !== 0) $d = '55'.$d;
  return $d;
}
function syncCommunityAfterPhoneUpdate(mysqli $db, string $cliente_uuid, string $celular, string $cpf) {
  $now        = date('Y-m-d H:i:s');
  $person_key = build_person_key_from_phone($celular);
  if ($person_key === '') return;

  $cpf_digits = preg_replace('/\D+/', '', $cpf);

  $stmt = $db->prepare("SELECT id FROM wpp_groups_related WHERE person_key = ? LIMIT 1");
  $stmt->bind_param('s', $person_key);
  $stmt->execute();
  $res = $stmt->get_result();
  $found = ($res && $res->num_rows > 0);
  $stmt->close();

  if ($found) {
      $stmt = $db->prepare("UPDATE wpp_groups_related SET customer_id=?, status=1, updated_at=? WHERE person_key=?");
      $stmt->bind_param('sss', $cliente_uuid, $now, $person_key);
      $stmt->execute();
      $stmt->close();

      $resp = statusEntidade($cpf_digits,'S');
      $status = $resp ? 1 : 2; // seu critério
      $stmt = $db->prepare("UPDATE customers SET ativo=?, wpp_group_status=1 WHERE cliente_uuid=?");
      $stmt->bind_param('is', $status, $cliente_uuid);
      $stmt->execute();
      $stmt->close();
  } else {
      $cfg = get_data('admin_config', 'community_required');
      $resp = statusEntidade($cpf_digits,'N');
      if ($cfg) {
          $stmt = $db->prepare("UPDATE customers SET ativo=0, wpp_group_status=0 WHERE cliente_uuid=?");
          $stmt->bind_param('s', $cliente_uuid);
          $stmt->execute();
          $stmt->close();
      }
  }
}

// ---- executa e imprime JSON
$return = cadastrar_usuario($data, $database_connection);
echo json_encode($return, JSON_UNESCAPED_UNICODE);
exit;
