<?php

session_start();

require_once $_SERVER['DOCUMENT_ROOT'] . '/wp-load.php';

global $database_connection;

header('Content-Type: application/json; charset=utf-8');

// --- config ---
$CLIENT_ID = '252915568566-cfevejp4p92eteco5u2fsbob4j2v645r.apps.googleusercontent.com';

// --- helpers ---
function json_fail($m){ echo json_encode(['success'=>false,'message'=>$m], JSON_UNESCAPED_UNICODE); exit; }
function column_exists(mysqli $c,$t,$col){ $st=$c->prepare("SHOW COLUMNS FROM `$t` LIKE ?"); if(!$st) return false; $st->bind_param('s',$col); $st->execute(); $r=$st->get_result(); $ok=$r && $r->num_rows>0; $st->close(); return $ok; }
function google_validate_idtoken($id_token,$client_id){
  $url='https://oauth2.googleapis.com/tokeninfo?id_token='.urlencode($id_token);
  $resp=@file_get_contents($url); if($resp===false) return [false,null];
  $data=json_decode($resp,true); if(!is_array($data)) return [false,null];
  if(empty($data['aud']) || $data['aud']!==$client_id) return [false,null];
  if(!empty($data['exp']) && time()>intval($data['exp'])) return [false,null];
  return [true,$data];
}
function needs_completion($row){
  $req=['cpf','celular','rua','numero','bairro','cidade','estado','cep','genero','data_nascimento'];
  foreach($req as $f){ if(empty($row[$f]) || $row[$f]==='0000-00-00') return true; }
  return false;
}

// --- entrada ---
$id_token = $_POST['credential'] ?? '';
if(!$id_token) json_fail('Credencial ausente.');

// --- valida token ---
list($ok,$payload) = google_validate_idtoken($id_token,$CLIENT_ID);
if(!$ok) json_fail('Token inválido.');

$google_id = $payload['sub'] ?? null;
$email     = $payload['email'] ?? null;
$name      = $payload['name'] ?? '';
$verified  = !empty($payload['email_verified']) ? 1 : 0;
$picture   = $payload['picture'] ?? '';

if(!$google_id || !$email) json_fail('Dados essenciais ausentes.');

// --- checa colunas opcionais ---
$has_google_id       = column_exists($database_connection,'customers','google_id');
$has_google_verified = column_exists($database_connection,'customers','google_verified');
$has_picture         = column_exists($database_connection,'customers','picture');
$has_provider        = column_exists($database_connection,'provider','provider') || column_exists($database_connection,'customers','provider'); // tolerância
$has_last_login      = column_exists($database_connection,'customers','last_login');

// --- tenta encontrar usuário existente ---
$userRow = null;
if($has_google_id){
  $st=$database_connection->prepare("SELECT * FROM customers WHERE google_id=? LIMIT 1");
  $st->bind_param('s',$google_id); $st->execute(); $r=$st->get_result();
  if($r && $r->num_rows>0) $userRow=$r->fetch_assoc();
  $st->close();
}
if(!$userRow){
  $st=$database_connection->prepare("SELECT * FROM customers WHERE email=? LIMIT 1");
  $st->bind_param('s',$email); $st->execute(); $r=$st->get_result();
  if($r && $r->num_rows>0) $userRow=$r->fetch_assoc();
  $st->close();
}

// --- se existir: faz login, atualiza metadados e informa se precisa completar ---
if($userRow){
  $userID = $userRow['cliente_uuid'];
  // atualiza metadados
  $sets=[]; $types=''; $vals=[];
  if($has_google_id && empty($userRow['google_id'])){ $sets[]='google_id=?'; $types.='s'; $vals[]=$google_id; }
  if($has_google_verified){ $sets[]='google_verified=?'; $types.='i'; $vals[]=$verified; }
  if($has_picture){ $sets[]='picture=?'; $types.='s'; $vals[]=$picture; }
  if($has_provider){ $sets[]='provider=?'; $types.='s'; $vals[]='google'; }
  if($has_last_login){ $sets[]='last_login=NOW()'; }
  if($sets){
    $sql="UPDATE customers SET ".implode(',',$sets)." WHERE cliente_uuid=?";
    $types.='s'; $vals[]=$userID;
    $up=$database_connection->prepare($sql); $up->bind_param($types, ...$vals); $up->execute(); $up->close();
  }
  $_SESSION['usuario']=['id'=>$userID];
  echo json_encode(['success'=>true,'need_complete'=>needs_completion($userRow),'mode'=>'update']); exit;
}

// --- NÃO EXISTE: guarda dados em sessão, não insere no banco ---
$_SESSION['google_onboarding'] = [
  'google_id' => $google_id,
  'email'     => $email,
  'name'      => $name,
  'verified'  => $verified,
  'picture'   => $picture,
  'at'        => time()
];

echo json_encode(['success'=>true,'need_complete'=>true,'mode'=>'insert']);