<?php

require_once $_SERVER['DOCUMENT_ROOT'] . '/wp-load.php';
include get_template_directory() . '/web-panel/functions/database-connection.php';


$json_data = file_get_contents('php://input');
$data = json_decode($json_data, true);

if (!is_array($data)) {
    echo json_encode([]);
    exit;
}

$retorno = [];

foreach ($data as $item) {
    $codigo = $item['codigo'] ?? null;
    $loja_slug = $item['loja'] ?? null;
    $smart = $item['smart_campaign'] ?? null;

    if (!$codigo || !$loja_slug) continue;

    // Verifica se há campanha smart ativa
    $smart_ativo = false;
    if ($smart) {
        $sql = "SELECT data_final FROM smart_campaign WHERE id = ?";
        $stmt = $database_connection->prepare($sql);
        $stmt->bind_param("i", $smart);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($row = $result->fetch_assoc()) {
            $data_final = strtotime($row['data_final']);
            $agora = time(); // timestamp atual

            if ($data_final >= $agora) {
                $smart_ativo = true; // campanha ainda ativa
            }
        }
        $stmt->close();
    }

    // Se smart ativo, busca também drafts
    $post_status = $smart_ativo ? ['publish', 'draft'] : 'publish';

    $args = [
        'post_type'   => 'oferta',
        'post_status' => $post_status,
        'meta_query'  => [
            [
                'key'     => 'codigoProduto',
                'value'   => $codigo,
                'compare' => '='
            ]
        ]
    ];

    $query = new WP_Query($args);

    if ($query->have_posts()) {
        while ($query->have_posts()) {
            $query->the_post();

            $produto_id = get_the_ID();

           
            $precos_raw = get_field('precos', $produto_id);
            $precos = is_string($precos_raw) ? json_decode($precos_raw, true) : $precos_raw;

            if (!is_array($precos)) continue;

            // var_dump($precos);

            foreach ($precos as $preco) {
                $lojas = explode(';', $preco['loja'] ?? '');

                foreach ($lojas as $loja) {
                    $loja_formatada = 'loja-' . ltrim($loja, '0');

                    if ($loja_formatada === $loja_slug) {
                        $retorno[] = [
                            'codigo' => $codigo,
                            'loja'   => $loja_slug,
                            'status' => 'publicado',
                            'smart'  => $smart_ativo
                        ];
                        break 2; 
                    }
                }
            }
        }
    }

    wp_reset_postdata();
}

echo json_encode($retorno);
exit;