<?php  
    
    if(!current_user_can('administrator') && !current_user_can('contributor') && !current_user_can('editor')){
        if(isset($_SESSION['usuario']) && !empty($_SESSION['usuario'])){
            $idUsuario = $_SESSION['usuario']['id'];
        }else{
            echo '<script>window.location.href = "' . esc_url(home_url('autenticacao')) . '";</script>';
        }
    }else{
        $idUsuario = $_SESSION['usuario']['id'] ?? null; // Use coalescência nula para evitar variáveis indefinidas
        if(!empty($_GET['frontadmin']) && $_GET['frontadmin'] == 'true'){
			echo "<style>body :is(.infosCliente, .headApp, .boxInd, .atalhosApp){ display:none !important }</style>";
        }else{
            if(!isset($_SESSION['usuario']) || empty($_SESSION['usuario'])){
                echo '<script>window.location.href = "' . esc_url(home_url('autenticacao')) . '";</script>';
            }
        }
    }

    include_once get_template_directory() . '/mobile-view/includes/get-info.php';

	$valor_minimo = get_data('ecommerce_config', 'valor_minimo_compra') ?? 0;
	$tempoPrevisto = get_data('ecommerce_config', 'tempo_previsto') ?? 0;
    $ativo = get_data('ecommerce_config', 'ativo') ?? 0;

	$community_warning = get_data('admin_config', 'community_required') ?? 0;


?>

<?php 
	$tabloide = false; 
	$countTabloide = 0;

	if ($idUsuario) {
		$sql_tags = "SELECT id_tag FROM related_tag WHERE id_customer = '$idUsuario'";
		$result_tags = mysqli_query($database_connection, $sql_tags);
		$user_tags = [];
		while ($row = mysqli_fetch_assoc($result_tags)) {
			$user_tags[] = $row['id_tag'];
		}
		$sql_loja = "SELECT loja_mais_frequentada FROM customers WHERE cliente_uuid = '$idUsuario'";
		$result_loja = mysqli_query($database_connection, $sql_loja);
		$row_loja = mysqli_fetch_assoc($result_loja);
		$user_loja = $row_loja['loja_mais_frequentada'];

	}
?>

<script>
    const idUsuario      = <?= json_encode($idUsuario)  ?>;
    const userTags       = <?= json_encode($user_tags ?? []) ?>; // 👈 AQUI
    const valor_minimo   = <?= json_encode((float) str_replace(',', '.', $valor_minimo)) ?>;
    const ativo          = <?= $community_warning ?>;
    const ecommerce_ativo= <?= json_encode(!empty($ativo) ? (int) $ativo : 0) ?>;
    let logo             = '<?= get_data('app_config', 'logo') ?>';
</script>



<section class="head__app" style="background-image: url('<?= get_data('app_config', 'background'); ?>');">

	<div class="head-content">
		<h2 id="step-title">
			<div class="logo">
				<img src="<?= get_data('app_config', 'logo') ?>" alt="Logo">
			</div>
		</h2>

		<p id="step-description">
			<a onclick="event.preventDefault(); event.stopPropagation(); $('#minha-conta').addClass('open');">
				<i class="fa-solid fa-bars"></i>
			</a>
			Olá, <?= esc_html(get_info('nome', $_SESSION['usuario']['id'] ?? 0)); ?>!
		</p>

		<div class="bar__icons">
			
			<div class="push__notification" style="background-color: <?= get_data('app_config', 'color'); ?>;">
				<a onclick="event.preventDefault(); event.stopPropagation(); $('#notificacao').addClass('open');">
					<i class="fa-solid fa-bell"></i>
					<?php if ($countTabloide == 0) { ?>
						<span id="notificacaoBadge" class="badge" ><?php echo $countTabloide; ?></span>
					<?php } ?>
				</a>
			</div>

			<div class="stores" style="background-color: <?= get_data('app_config', 'color'); ?>;">
				<a onclick="event.preventDefault(); event.stopPropagation(); $('#Lojas').addClass('open');">
					<i class="fa-solid fa-store"></i>
				</a>
			</div>

			<div class="bags" style="background-color: <?= get_data('app_config', 'color'); ?>;">
				<a onclick="event.preventDefault(); event.stopPropagation(); $('#sacola').addClass('open');">
					<i class="fa-solid fa-bag-shopping"></i>
				</a>
			</div>

		</div>

	</div>

	<div class="last__update">
		Atualizado em: <span id="lastUpdateCheck"></span>
	</div>

</section>

<button id="btnUponPage" class="btn-up">
	<i class="fa-solid fa-up-long"></i>
</button>

<section class="body__app">
    <div class="container-fluid" id="step-content">

		<div id="infosCliente">

			<?php 
				if(get_field('cobrar_assinatura', 'options') == true): 
					$diasAtivo = get_info('dias_ativacao', $_SESSION['usuario']['id'] ?? 0); 
					$dataAtual = strtotime(date("d-m-Y"));
			?>
			<div class="item">
				<div class="blocos__info">
					<?php if (strtotime($diasAtivo) > $dataAtual) {  ?>
					<div class="head__blocos__info">
						<p>Ativo até:</p>
						<i class="fa-solid fa-user-check"></i> 
					</div>
					<div class="body__blocos__info">
						<span class="bigValue"><?= str_replace('-', '/',$diasAtivo); ?></span>
					</div>
				<?php }else{ ?>
					<div class="head__blocos__info">
						<p>Você está</p>
						<i class="fa-solid fa-user-check"></i> 
					</div>
					<div class="body__blocos__info">
						<span class="bigValue">Inativo</span>
					</div>
				<?php } ?>
				</div>
			</div>
			<?php endif; ?>

			<div class="item">
				<a onclick="event.preventDefault(); event.stopPropagation(); $('#compras').addClass('open');">
					<div class="blocos__info">
						<div class="head__blocos__info">
							<p>Poupômetro</p>
							<i class="fa-solid fa-percent"></i> 
						</div>
						<div class="body__blocos__info">
							<span>R$</span>
							<span class="bigValue"><?= isset($economiaGeral) && $economiaGeral > 0 ? number_format($economiaGeral, '2', ',', '.') : "0,00"; ?></span>
						</div>
						<div class="foot__blocos__info">
							<p>Ver compras <i class="fa-solid fa-arrow-right"></i></p>
						</div>
					</div>
				</a>
			</div>

			<div class="item">
				<a onclick="event.preventDefault(); event.stopPropagation(); $('#compras').addClass('open');">
					<div class="blocos__info">
						<div class="head__blocos__info">
							<p>Compras</p>
							<i class="fa-solid fa-cart-shopping"></i> 
						</div>
						<div class="body__blocos__info">
							<span class="bigValue"><?= isset($compras) ? count($compras) : 0; ?></span>
						</div>
						<div class="foot__blocos__info">
							<p>Ver compras <i class="fa-solid fa-arrow-right"></i></p>
						</div>
					</div>
				</a>
			</div>

			<div class="item">
				<a onclick="event.preventDefault(); event.stopPropagation(); $('#indicados').addClass('open');">
					<div class="blocos__info">
						<div class="head__blocos__info">
							<p>Indicações</p>
							<i class="fa-solid fa-user-plus"></i> 
						</div>
						<div class="body__blocos__info">
							<span class="bigValue"><?= isset($indicados) ? count($indicados) : 0; ?></span>
						</div>
						<div class="foot__blocos__info">
							<p>Ver Indicações <i class="fa-solid fa-arrow-right"></i></p>
						</div>
					</div>
				</a>
			</div>

			<div class="item">
				<a onclick="event.preventDefault(); event.stopPropagation(); $('#extratos').addClass('open');">
					<div class="blocos__info">
						<div class="head__blocos__info">
							<p>Créditos</p>
							<i class="fa-solid fa-money-bill-transfer"></i> 
						</div>
						<div class="body__blocos__info">
							<span>R$</span>
							<span class="bigValue valueCredit"><?= esc_html(get_info('credito', $_SESSION['usuario']['id'] ?? 0)); ?></span>
						</div>
						<div class="foot__blocos__info">
							<p>Ver Extratos <i class="fa-solid fa-arrow-right"></i></p>
						</div>
					</div>
				</a>
			</div>

			<div class="item">
				<a onclick="event.preventDefault(); event.stopPropagation(); $('#cupons').addClass('open');">
					<div class="blocos__info">
						<div class="head__blocos__info">
							<p>Cupons de Desconto</p>
							<i class="fa-solid fa-tags"></i> 
						</div>
						<div class="body__blocos__info">
							<span class="bigValue valueCupom"><?= isset($cuponsDesconto) ? count($cuponsDesconto) : 0; ?></span>
						</div>
						<div class="foot__blocos__info">
							<p>Ver Cupons <i class="fa-solid fa-arrow-right"></i></p>
						</div>
					</div>
				</a>
			</div>

		</div>

		<div class="boxInd">
			<?php if(get_field('aplicar_sistema_de_indicacao', 'options') == "sim"): ?>
				<label>Indique seu link para conhecidos e receba
				<?php if(get_field('tipo_da_comissao', 'options') == "valor_fixo"): ?>
					R$ <?= number_format(get_field('valor_indicacao', 'options'), '2', ',', '.'); ?>
				<?php elseif(get_field('tipo_da_comissao', 'options') == "percentual"): ?>
					<?= get_field('valor_indicacao', 'options') ?> % do valor
				<?php endif; ?> 
					por cadastro quando efetuarem 
				<?php if(get_field('frequencia', 'options') == 'primeira_compra'): ?>
					a primeira compra!
				<?php  elseif(get_field('frequencia', 'options') == 'vitalicio'):  ?>
					suas compras
				<?php endif; ?>
				</label>
			<?php else: ?>
				<label>Indique o clube para seus amigos</label>
			<?php endif; ?>
			<div class="clipboard">
				<input onclick="copy()" class="copy-input" value="<?= home_url().'/?indicacao='.$_SESSION['usuario']['id']; ?>" id="copyClipboard" readonly>
				<button class="copy-btn" id="copyButton" onclick="copy()"><i class="fa-solid fa-copy"></i></button>
				<div id="copied-success" class="copied-tooltip">Copiado!</div>
			</div>
		</div>

		<?php if(get_field('aplicar_cashback', 'options') == 'sim'){ ?>
			<div class="boxCashback">
			<?php if(get_field('aplicacao_do_cashback', 'options') == 'produto_especifico'){ ?>
				<p><strong>Cashback 💸</strong><br>Estamos pagando cashback por você comprar os nossos produtos! Os valores estão especificados diretamente em cada produto.</p>
			<?php }elseif(get_field('aplicacao_do_cashback', 'options') != 'produto_especifico'){ ?>
				
				<?php if(get_field('aplicacao_do_cashback', 'options') == 'valor_total'){ ?>
					<p><strong>Cashback 💸</strong><br>Estamos pagando cashback por você comprar todos nossos produtos!</p>
				<?php }elseif(get_field('aplicacao_do_cashback', 'options') == 'valor_clube'){ ?>
						<p><strong>Cashback 💸</strong><br>Estamos pagando cashback por você comprar os produtos do Clube!</p>
				<?php }elseif(get_field('aplicacao_do_cashback', 'options') == 'valor_sem_clube'){ ?>
					<p><strong>Cashback 💸</strong><br>Estamos pagando cashback por você comprar nossos produtos fora do Clube, junto com algum que faz parte!</p>
				<?php } ?>

				<?php if(get_field('tipo_do_cashback', 'options') == 'valor_fixo'){ ?>
					<p><strong>Valor:</strong> R$ <?= number_format(get_field('valor_cashback', 'options'), '2', ',', '.'); ?> de volta!</p>
				<?php }else{ ?>
					<p><strong>Valor:</strong> <?= get_field('valor_cashback', 'options'); ?>% de volta!</p>
				<?php } ?>

			<?php } ?>
			<?php if(get_field('valor_minimo', 'options') > 0){ ?>
				<p><strong>Valor mínimo da compra para participar do benefício:</strong> R$ <?= number_format(get_field('valor_minimo', 'options'), '2', ',', '.'); ?></p>
			<?php } ?>
			</div>
		<?php } ?>

		<div id="bannerSkeleton" class="justify-content-center align-items-center" style="height: 450px; padding: 10px;">
			<div class="skeleton-banner w-100 h-100"></div>
		</div>

		<div class="bannersRotate">
        	<div id="bannerRotate"></div>
    	</div>
		
		<div class="row">

			<div class="section" id="stickySection">
				<div id="section">
					<div class="sectionInfos">
						<div class="sectionValue wrap-container">
							<div id="categoriesArea" class="categories-flex sortable-container"></div>
						</div>
					</div>
				</div>
			</div>

			<div id="productsArea" class="row sortable-sections px-0">
				
			</div>
		
		</div>

	</div>

</section>

<article class="app__bar__menu">

	<ul>
		<li>
			<a onclick="$('#jornais').addClass('open');">
				<i class="fa-regular fa-newspaper"></i>
				Folhetos
			</a>
		</li>
		<li class="active">
			<a onclick="abrirLateralFiltro();">
				<i class="fa-solid fa-magnifying-glass" style="background-color: <?= get_data('app_config', 'color'); ?>"></i>
				Buscar
			</a>
		</li>
		<li>
			<!-- <a onclick="event.preventDefault(); event.stopPropagation(); modalWppCommunity(<? # $community_warning; ?>); $('#modal-carrinho').addClass('open');"> -->
			<a onclick="event.preventDefault(); event.stopPropagation(); $('#modal-carrinho').addClass('open');">
				<i class="fa-solid fa-cart-shopping"></i>
				Carrinho <span id="contador-carrinho" class="badge">0</span>
			</a>
		</li>
	</ul>

</article>

<?php include_once get_template_directory().'/web-panel/modules/offer/includes/modal-all-products.php'; ?>
<?php include_once get_template_directory().'/mobile-view/includes/modal/modal-stores.php'; ?>
<?php # include_once get_template_directory().'/mobile-view/includes/modal/modal-wpp-group.php'; ?>
<?php include_once get_template_directory().'/mobile-view/includes/modal/modal-shortcuts.php'; ?>
<?php include_once get_template_directory().'/mobile-view/includes/modal/modal-extract.php'; ?>
<?php include_once get_template_directory().'/mobile-view/includes/modal/modal-indicated.php'; ?>
<?php include_once get_template_directory().'/mobile-view/includes/modal/modal-sales.php'; ?>
<?php include_once get_template_directory().'/mobile-view/includes/modal/modal-change-password.php'; ?>
<?php include_once get_template_directory().'/mobile-view/includes/modal/modal-product.php'; ?>
<?php include_once get_template_directory().'/mobile-view/includes/modal/modal-discount-coupon.php'; ?>


<?php if(current_user_can('administrator') || current_user_can('contributor') || current_user_can('editor')) include_once get_template_directory().'/mobile-view/includes/modal/modal-images.php'; ?>
<?php include_once get_template_directory().'/mobile-view/includes/modal/modal-cart.php'; ?>